/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.util;

import com.buuz135.functionalstorage.util.StorageTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CompactingUtil {
    private final Level level;
    private List<Result> results;
    private final int resultAmount;

    public CompactingUtil(Level level, int resultAmount) {
        this.level = level;
        this.resultAmount = resultAmount;
        this.results = new ArrayList<Result>();
    }

    public void setup(ItemStack stack) {
        this.results.add(new Result(stack, 1));
        Result result = this.findUpperTier(stack);
        if (!result.getResult().m_41619_()) {
            this.results.add(result);
            if (this.results.size() < this.resultAmount && !(result = this.findUpperTier(result.getResult())).getResult().m_41619_()) {
                result.setNeeded(result.getNeeded() * this.results.get(this.results.size() - 1).getNeeded());
                this.results.add(result);
            }
        }
        boolean canFind = true;
        while (canFind && this.results.size() < this.resultAmount) {
            result = this.findLowerTier(this.results.get(0).getResult());
            if (!result.getResult().m_41619_()) {
                for (Result result12 : this.results) {
                    result12.setNeeded(result12.getNeeded() * result.getNeeded());
                }
                result.setNeeded(1);
                this.results.add(0, result);
                continue;
            }
            canFind = false;
        }
        while (this.results.size() < this.resultAmount) {
            this.results.add(0, new Result(ItemStack.f_41583_, 1));
        }
        this.results.stream().filter(result1 -> result1.getResult().m_41613_() > 0).forEach(result1 -> result1.setNeeded(result1.getNeeded() / result1.getResult().m_41613_()));
    }

    public List<Result> getResults() {
        return this.results;
    }

    private Result findUpperTier(ItemStack stack) {
        int sizeCheck = 9;
        CraftingContainer container = this.createContainerAndFill(3, stack);
        List<ItemStack> outputs = this.findAllMatchingRecipes(container);
        ArrayList<ItemStack> realOutputs = new ArrayList();
        if (outputs.size() == 0) {
            sizeCheck = 4;
            container = this.createContainerAndFill(2, stack);
            outputs = this.findAllMatchingRecipes(container);
        }
        if (stack.m_204117_(StorageTags.IGNORE_CRAFTING_CHECK)) {
            realOutputs = outputs;
        } else if (outputs.size() > 0) {
            for (ItemStack output : outputs) {
                container = this.createContainerAndFill(1, output);
                List<ItemStack> reversed = this.findAllMatchingRecipes(container);
                for (ItemStack reversedStack : reversed) {
                    if (reversedStack.m_41613_() != sizeCheck || !ItemStack.m_41746_((ItemStack)reversedStack, (ItemStack)stack)) continue;
                    realOutputs.add(output);
                }
            }
        }
        ItemStack similar = this.findSimilar(stack, realOutputs);
        if (!similar.m_41619_()) {
            return new Result(similar, sizeCheck);
        }
        if (realOutputs.size() > 0) {
            return new Result((ItemStack)realOutputs.get(0), sizeCheck);
        }
        return new Result(ItemStack.f_41583_, 0);
    }

    private Result findLowerTier(ItemStack stack) {
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        HashMap<ItemStack, Integer> candidatesRate = new HashMap<ItemStack, Integer>();
        block0: for (CraftingRecipe craftingRecipe : this.level.m_7465_().m_44013_(RecipeType.f_44107_)) {
            ItemStack match;
            ItemStack output = craftingRecipe.m_8043_();
            if (!ItemStack.m_41746_((ItemStack)stack, (ItemStack)output) || (match = this.tryMatch(stack, (NonNullList<Ingredient>)craftingRecipe.m_7527_())).m_41619_()) continue;
            int recipeSize = craftingRecipe.m_7527_().size();
            if (stack.m_204117_(StorageTags.IGNORE_CRAFTING_CHECK)) {
                candidates.add(match);
                candidatesRate.put(match, recipeSize);
            }
            CraftingContainer container = this.createContainerAndFill(1, output);
            List<ItemStack> matchStacks = this.findAllMatchingRecipes(container);
            for (ItemStack matchStack : matchStacks) {
                if (!ItemStack.m_41746_((ItemStack)match, (ItemStack)matchStack) || matchStack.m_41613_() != recipeSize) continue;
                candidates.add(match);
                candidatesRate.put(match, recipeSize);
                continue block0;
            }
        }
        ItemStack similar = this.findSimilar(stack, candidates);
        if (!similar.m_41619_()) {
            return new Result(similar, (Integer)candidatesRate.get(similar));
        }
        if (candidates.size() > 0) {
            return new Result((ItemStack)candidates.get(0), (Integer)candidatesRate.get(candidates.get(0)));
        }
        return new Result(ItemStack.f_41583_, 0);
    }

    private List<ItemStack> findAllMatchingRecipes(CraftingContainer crafting) {
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        for (CraftingRecipe recipe : this.level.m_7465_().m_44056_(RecipeType.f_44107_, (Container)crafting, this.level)) {
            ItemStack result;
            if (!recipe.m_5818_((Container)crafting, this.level) || (result = recipe.m_5874_((Container)crafting)).m_41619_()) continue;
            candidates.add(result);
        }
        return candidates;
    }

    private ItemStack findSimilar(ItemStack reference, List<ItemStack> candidates) {
        ResourceLocation referenceName = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)reference.m_41720_());
        if (referenceName != null) {
            for (ItemStack candidate : candidates) {
                ResourceLocation matchName = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)candidate.m_41720_());
                if (matchName == null || !referenceName.m_135827_().equals(matchName.m_135827_())) continue;
                return candidate;
            }
        }
        return candidates.size() > 0 ? candidates.get(0) : ItemStack.f_41583_;
    }

    private ItemStack tryMatch(ItemStack stack, NonNullList<Ingredient> ingredients) {
        if (ingredients.size() != 9 && ingredients.size() != 4) {
            return ItemStack.f_41583_;
        }
        Ingredient refIngredient = (Ingredient)ingredients.get(0);
        ItemStack[] refMatchingStacks = refIngredient.m_43908_();
        if (refMatchingStacks.length == 0) {
            return ItemStack.f_41583_;
        }
        int n = ingredients.size();
        for (int i = 1; i < n; ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            ItemStack match = ItemStack.f_41583_;
            for (ItemStack ingItemMatch : refMatchingStacks) {
                if (!ingredient.test(ingItemMatch)) continue;
                match = ingItemMatch;
                break;
            }
            if (!match.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        ItemStack match = this.findSimilar(stack, Arrays.asList(refMatchingStacks));
        if (match.m_41619_()) {
            match = refMatchingStacks[0];
        }
        return match;
    }

    private CraftingContainer createContainerAndFill(int size, ItemStack stack) {
        CraftingContainer inventoryCrafting = new CraftingContainer(new AbstractContainerMenu(null, 0){

            public ItemStack m_7648_(Player p_38941_, int p_38942_) {
                return null;
            }

            public boolean m_6875_(Player playerIn) {
                return false;
            }
        }, size, size);
        for (int i = 0; i < size * size; ++i) {
            inventoryCrafting.m_6836_(i, stack.m_41777_());
        }
        return inventoryCrafting;
    }

    public static class Result {
        private ItemStack result;
        private int needed;

        public Result(ItemStack result, int needed) {
            this.result = result;
            this.needed = needed;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }

        public int getNeeded() {
            return this.needed;
        }

        public void setNeeded(int needed) {
            this.needed = needed;
        }

        public String toString() {
            return "Result{result=" + this.result + ", needed=" + this.needed + "}";
        }
    }
}

